/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.blocks.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.herbalbrews.client.gui.handler.CauldronGuiHandler;
import net.satisfy.herbalbrews.core.registry.EntityTypeRegistry;
import net.satisfy.herbalbrews.core.registry.ObjectRegistry;
import net.satisfy.herbalbrews.core.world.ImplementedInventory;
import net.satisfy.herbalbrews.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CauldronBlockEntity
extends BlockEntity
implements ImplementedInventory,
BlockEntityTicker<CauldronBlockEntity>,
MenuProvider {
    public static final int CAPACITY = 5;
    private static final int[] SLOTS_FOR_SIDE = new int[]{0, 4};
    private static final int[] SLOTS_FOR_UP = new int[]{1, 2};
    private static final int[] SLOTS_FOR_DOWN = new int[]{3};
    private NonNullList<ItemStack> inventory;
    private int brewingTime = 0;
    private int totalBrewingTime;
    private final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CauldronBlockEntity.this.brewingTime;
                case 1 -> CauldronBlockEntity.this.totalBrewingTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CauldronBlockEntity.this.brewingTime = value;
                    break;
                }
                case 1: {
                    CauldronBlockEntity.this.totalBrewingTime = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public CauldronBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.CAULDRON_BLOCK_ENTITY.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.brewingTime = nbt.m_128448_("BrewingTime");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128376_("BrewingTime", (short)this.brewingTime);
    }

    public void tick(Level world, BlockPos pos, BlockState state, CauldronBlockEntity blockEntity) {
        if (world.f_46443_) {
            return;
        }
        boolean dirty = false;
        if (this.canCraft()) {
            ++this.brewingTime;
            if (this.brewingTime >= this.totalBrewingTime) {
                this.brewingTime = 0;
                this.craft(world);
                dirty = true;
            }
        } else {
            this.brewingTime = 0;
        }
        if (dirty) {
            this.m_6596_();
        }
    }

    private boolean canCraft() {
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.m_8020_(i);
            if (!stack.m_41619_() && stack.m_41720_() instanceof PotionItem) continue;
            return false;
        }
        ItemStack catalyst = this.m_8020_(4);
        if (catalyst.m_41619_() || catalyst.m_41720_() != ObjectRegistry.HERBAL_INFUSION.get()) {
            return false;
        }
        ItemStack output = this.m_8020_(3);
        return output.m_41619_();
    }

    private void craft(Level world) {
        ArrayList combinedEffects = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            ItemStack potionStack = this.m_8020_(i);
            List potionEffects = PotionUtils.m_43547_((ItemStack)potionStack);
            combinedEffects.addAll(potionEffects);
        }
        if (combinedEffects.isEmpty()) {
            return;
        }
        HashMap<MobEffect, MobEffectInstance> uniqueEffectsMap = new HashMap<MobEffect, MobEffectInstance>();
        for (MobEffectInstance effectInstance : combinedEffects) {
            MobEffect effect = effectInstance.m_19544_();
            if (uniqueEffectsMap.containsKey(effect) && effectInstance.m_19564_() <= ((MobEffectInstance)uniqueEffectsMap.get(effect)).m_19564_()) continue;
            uniqueEffectsMap.put(effect, new MobEffectInstance(effect, effectInstance.m_19557_(), effectInstance.m_19564_()));
        }
        ItemStack outputPotion = new ItemStack((ItemLike)ObjectRegistry.FLASK.get());
        CompoundTag outputTag = outputPotion.m_41784_();
        ListTag newEffectsList = new ListTag();
        RandomSource random = world != null ? world.m_213780_() : RandomSource.m_216327_();
        int randomTexture = random.m_188503_(6) + 1;
        outputTag.m_128405_("CustomModelData", randomTexture);
        for (MobEffectInstance effectInstance : uniqueEffectsMap.values()) {
            CompoundTag effectTag = new CompoundTag();
            int effectId = BuiltInRegistries.f_256974_.m_7447_((Object)effectInstance.m_19544_());
            if (effectId == -1) continue;
            effectTag.m_128405_("Id", effectId);
            effectTag.m_128344_("Amplifier", (byte)effectInstance.m_19564_());
            effectTag.m_128405_("Duration", effectInstance.m_19557_());
            newEffectsList.add((Object)effectTag);
        }
        outputTag.m_128365_("CustomPotionEffects", (Tag)newEffectsList);
        this.m_6836_(3, outputPotion);
        for (int i = 0; i < 3; ++i) {
            this.m_7407_(i, 1);
        }
        this.m_7407_(4, 1);
    }

    @Override
    public int @NotNull [] m_7071_(Direction side) {
        if (side.equals((Object)Direction.UP)) {
            return SLOTS_FOR_UP;
        }
        if (side.equals((Object)Direction.DOWN)) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDE;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        ItemStack stackInSlot = (ItemStack)this.inventory.get(slot);
        boolean dirty = !stack.m_41619_() && ItemStack.m_41656_((ItemStack)stack, (ItemStack)stackInSlot) && ItemStack.m_41728_((ItemStack)stack, (ItemStack)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (slot < 3 && !dirty) {
            this.totalBrewingTime = PlatformHelper.getBrewingDuration();
            this.brewingTime = 0;
            this.m_6596_();
        }
        if (slot == 4 && !dirty) {
            this.m_6596_();
        }
    }

    @Override
    public boolean m_6542_(Player player) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new CauldronGuiHandler(syncId, inv, (Container)this, this.propertyDelegate);
    }
}

